package gov.va.med.mhv.usermgmt.main.service.validator;

import java.util.LinkedHashMap;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.core.validate.Validator;
import gov.va.med.mhv.usermgmt.common.dto.MyLinksDTO;


@Component
public class MyLinksValidator extends Validator {

	private static final String DISPLAY_NAME="Display Name";
	private static final String LINK="Link";

	public ResponseUtil fieldValidations(MyLinksDTO myLinksDTO) {
		ResponseUtil response = new ResponseUtil();

		LinkedHashMap<String, String> validationErrors = new LinkedHashMap<String, String>();
		validateRequired(myLinksDTO, validationErrors);
		validateInvalid(myLinksDTO, validationErrors);
		response.setValidationErrors(validationErrors);

		return response;

	}

	private void validateRequired(MyLinksDTO myLinksDTO, LinkedHashMap<String, String> validationErrors) {
		if(myLinksDTO.getDisplayName().trim().isEmpty() || myLinksDTO.getDisplayName()==null) {
			validationErrors.put(DISPLAY_NAME, DISPLAY_NAME + " is a required field.");	
		}
		

		if(myLinksDTO.getLink().trim().isEmpty() || myLinksDTO.getLink()==null) {
			validationErrors.put(LINK, LINK + " is a required field.");	
		}
		
	}
	
	public void validateInvalid(MyLinksDTO myLinksDTO, LinkedHashMap<String, String> validationErrors) {

		if (myLinksDTO.getDisplayName() != null) {
			String linkName = myLinksDTO.getLink().trim();

			if (linkName != null) {
				int linkSize = "http://".length();
				if (linkName.contains("http://") && !(linkName.length() > linkSize)) {
					validationErrors.put(LINK, "The link entered is invalid.");
				}
			}
		}

	}

}
